# 画面設計書 3-ヘルプモード（help?>）

## 概要

関数・マクロ・キーワードのドキュメントを検索・表示するREPLモードの設計書。Markdown形式のdocstringをターミナルにレンダリングする。

### 本画面の処理概要

本画面は、Julia REPLのヘルプモードであり、ユーザーが入力した識別子（関数名、マクロ名、キーワード等）に対応するドキュメント（docstring）を検索・整形・表示する。

**業務上の目的・背景**：Juliaプログラミング中にリファレンスドキュメントを即座に参照できるインタフェースを提供する。外部のドキュメントサイトを開くことなく、REPL上で関数のシグネチャ、引数説明、使用例を確認できるため、開発効率を大幅に向上させる。`@doc` マクロで定義されたdocstringを検索し、Markdownパーサーでパースした後、ターミナルに適した形式でレンダリングする。入力が見つからない場合はapropos検索（全文検索）にフォールバックする。

**画面へのアクセス方法**：Juliaプロンプト画面で `?` キーを行頭で入力すると本モードに遷移する。プロンプトが `help?>` に変わり、ヘルプ検索が可能になる。

**主要な操作・処理内容**：
1. ユーザーがヘルプモードのプロンプト（`help?>`）に識別子を入力する
2. `helpmode()` 関数が呼び出され、入力が `Meta.parse` でASTに変換される
3. キーワード・演算子の場合は `keywords` 辞書から直接ドキュメントを取得する
4. 関数・型の場合は `Docs.doc` / `Docs.resolve` でdocstringを取得する
5. 取得したMarkdown形式のドキュメントを `Markdown.parse` / `Markdown.MD` でパースする
6. パースされたドキュメントをターミナルにレンダリングして表示する
7. `??` プレフィックスで拡張ヘルプ（ソースコード表示等）を取得できる

**画面遷移**：
- 遷移元：Juliaプロンプト（`?` キー入力、行頭）
- 遷移先：Juliaプロンプト（`Backspace` 行頭、`Ctrl+C`）
- 履歴検索モードからヘルプモードの履歴を選択して遷移することも可能

**権限による表示制御**：権限による表示制御は存在しない。ただし、非公開シンボルへのアクセス時には内部アクセス警告が表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 129 | Docsシステム | 主機能 | @docマクロで定義されたdocstringの検索・取得。helpmode()がDocs.doc/Docs.resolve等を呼び出す |
| 106 | Markdown | 主機能 | 取得したdocstring（Markdown形式）のパース・ターミナルレンダリング |
| 102 | REPL | 補助機能 | REPLモジュール内のdocview.jlとして実装。helpmode関数がメインエントリポイント |
| 55 | 式オブジェクト（Expr） | 補助機能 | Meta.parseによる入力のAST解析。キーワード/演算子/マクロの判定に使用 |
| 73 | 型リフレクション | 補助機能 | subtypes等のリフレクション機能を用いた型情報のドキュメント表示 |
| 74 | メソッドリフレクション | 補助機能 | methods/whichによるメソッド情報取得とドキュメント内でのメソッドシグネチャ表示 |
| 107 | Unicode | 補助機能 | Unicode.normalizeによる入力文字列の正規化処理（apropos検索時） |
| 36 | テキスト出力 | 補助機能 | printlnstyledによるシンタックスハイライト付きドキュメント出力 |

## 画面種別

ドキュメント検索・表示（ヘルプモード）

## URL/ルーティング

該当なし（ターミナルベースのCLIアプリケーション）

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| 検索クエリ | 入力 | String | ヘルプを検索する識別子（関数名、マクロ名、キーワード等） |
| ドキュメント | 出力 | Markdown.MD | 検索結果のMarkdownドキュメント |
| 内部アクセス警告 | 出力 | String | 非公開シンボルアクセス時の警告メッセージ |

## 表示項目

| 項目名 | 表示内容 | 条件 |
|--------|----------|------|
| プロンプト | `help?> ` | ヘルプモード時。アクティブモジュールがMain以外の場合はプレフィックス付き |
| docstring | Markdownレンダリングされたドキュメント | 識別子に対応するdocstringが見つかった場合 |
| メソッドリスト | メソッドシグネチャの一覧 | 関数のドキュメント表示時 |
| apropos検索結果 | 全文検索によるマッチした識別子の一覧 | docstringが見つからなかった場合 |
| 拡張ヘルプ | ソースコード表示等の追加情報 | `??` プレフィックスで検索した場合 |
| 内部アクセス警告 | 非公開シンボルへのアクセス警告 | 非公開シンボルにアクセスした場合 |

## イベント仕様

### 1-ドキュメント検索（Enter）

ユーザーが識別子を入力してEnterを押下すると、`on_done` コールバックが `helpmode()` を呼び出す。`helpmode()` は入力をパースし、`@repl` マクロを介して `Base.Docs` の名前空間でドキュメント検索を実行する。結果はMarkdownとしてターミナルにレンダリングされる。

### 2-モード離脱（Backspace / Ctrl+C）

行頭で `Backspace` を押下するか、`Ctrl+C` を押下するとJuliaプロンプトに戻る。`mode_keymap` で定義された遷移ロジックにより `transition(s, julia_prompt)` が実行される。

## データベース更新仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | 情報 | Markdownレンダリングされたdocstring | 識別子が見つかった場合 |
| - | 警告 | 非公開シンボルアクセス警告 | 非公開シンボルへのアクセス時 |
| - | 情報 | apropos検索結果（全文検索マッチ一覧） | docstringが見つからなかった場合 |

## 例外処理

| 例外 | 発生条件 | 対応 |
|------|----------|------|
| パースエラー | 入力が不正な構文の場合 | キーワードまたはシンボルとして処理を試みる |
| ドキュメント未定義 | 入力に対応するdocstringが存在しない場合 | apropos検索にフォールバック |

## 備考

- `extended_help_on` は `??` プレフィックスで拡張ヘルプを有効にするためのグローバル参照
- `#` で始まる入力はコメントのヘルプとして処理される
- `using` / `import` はキーワードとして特別扱いされる
- `@macroname` と `@macroname()` は区別されて処理される（前者は全ドキュメント、後者は0引数定義のみ）
- `internal_accesses` セットにより非公開シンボルへのアクセスが追跡・警告される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ヘルプモードのデータ構造は `Base.Docs` モジュールのDocStr、Binding、MultiDocが中心である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | docs/Docs.jl | `base/docs/Docs.jl` | DocStr, Binding, MultiDoc構造体の定義。docstringの格納構造を確認 |
| 1-2 | docview.jl | `stdlib/REPL/src/docview.jl` | extended_help_on Ref（34行目）。ヘルプモード固有の状態管理 |

**読解のコツ**: Juliaのドキュメントシステムは `@doc` マクロによりモジュールのメタデータにdocstringを格納する。`Docs.meta()` でモジュール単位のドキュメントメタデータにアクセスできる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | docview.jl | `stdlib/REPL/src/docview.jl` | helpmode()関数（23-30行）: メインエントリポイント。内部で_helpmode()を呼び出す |
| 2-2 | docview.jl | `stdlib/REPL/src/docview.jl` | _helpmode()関数（36-77行）: 入力のパースとドキュメント検索式の構築 |

**主要処理フロー**:
1. **37行**: 入力文字列のstrip
2. **39-46行**: `??` プレフィックスの判定（拡張ヘルプ）
3. **48-54行**: `#` で始まる入力のコメントヘルプ処理
4. **55行**: `Meta.parse` による入力のパース
5. **57-72行**: キーワード/演算子/マクロの判定と式構築
6. **75行**: `@repl` マクロを介したドキュメント取得・表示

#### Step 3: ドキュメント検索・表示の流れを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | docview.jl | `stdlib/REPL/src/docview.jl` | formatdoc()（79-87行）: DocStrのMarkdownへの変換 |
| 3-2 | docview.jl | `stdlib/REPL/src/docview.jl` | parsedoc()（89-97行）: DocStrのパースとキャッシュ |

### プログラム呼び出し階層図

```
setup_interface() で help_mode の on_done を設定
    |
    +-- helpmode(io, line, mod)            [23行]
            |
            +-- _helpmode(io, line, mod)   [36行]
            |       +-- Meta.parse(line)   [55行]
            |       +-- キーワード/演算子判定
            |       +-- @repl マクロ実行    [75行]
            |
            +-- Markdown.insert_hlines()   [26行]
            +-- insert_internal_warning()  [27行]
```

### データフロー図

```
[入力]                  [処理]                         [出力]

ユーザー入力     -----> _helpmode()                -----> Markdown.MD
(識別子文字列)          |
                  Meta.parse() で AST構築
                        |
                  キーワード/演算子/関数の判定
                        |
                  Docs.doc() / Docs.resolve()
                        |
                  formatdoc() / parsedoc()
                        |
                  Markdown.parse()             -----> ターミナルレンダリング
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| docview.jl | `stdlib/REPL/src/docview.jl` | ソース | ヘルプモードのメインロジック。helpmode(), _helpmode() |
| Docs.jl | `base/docs/Docs.jl` | ソース | ドキュメントシステムのコア。DocStr, Binding, doc(), resolve() |
| Markdown | `stdlib/Markdown/src/` | ソース | Markdownパーサーとレンダラー |
| REPL.jl | `stdlib/REPL/src/REPL.jl` | ソース | ヘルプモードのPrompt設定（1304-1312行） |
| LineEdit.jl | `stdlib/REPL/src/LineEdit.jl` | ソース | モード遷移とキーマップ管理 |
